<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0"
xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
xmlns="http://www.w3.org/1999/xhtml">

<xsl:template match="filterSettings">
	<table class="filterSettings">
		<tr>
			<td class="key">Date Range:</td>
			<td class="value">
				<xsl:value-of select="@dateRange"/>
			</td>
		</tr>
		<tr>
			<td class="key">Accounts:</td>
			<td class="value">
				<span class="andMore">and XXX more</span>
				<span class="singleItem">1 account</span>
				<span class="multipleItems">XXX accounts</span>
				<span class="zeroItems">All Accounts</span>
				<ul>
					<xsl:apply-templates select="accounts/account"/>
				</ul>
			</td>
		</tr>
		<tr>
			<td class="key">Categories:</td>
			<td class="value">
				<span class="andMore">and XXX more</span>
				<span class="singleItem">1 category</span>
				<span class="multipleItems">XXX categories</span>
				<span class="zeroItems">All Categories</span>
				<ul>
					<xsl:apply-templates select="categoryTags/categoryTag"/>
				</ul>
			</td>
		</tr>
		<tr>
			<td class="key">Tags:</td>
			<td class="value">
				<span class="andMore">and XXX more</span>
				<span class="singleItem">1 tag</span>
				<span class="multipleItems">XXX tags</span>
				<span class="zeroItems">All Tags</span>
				<span class="tagSelectionType"><xsl:apply-templates select="userTags/tagSelectionType"/></span>
				<ul>
					<xsl:apply-templates select="userTags/userTag"/>
				</ul>
			</td>
		</tr>
	</table>
	<xsl:if test="count(@defaultDateRange) and count(accounts/account) = 0 and count(userTags/userTag) = 0 and count(categoryTags/categoryTag) = 0">
		<div class="filterDefaultSettings"></div>
	</xsl:if>
</xsl:template>


<xsl:template match="filterSettings/accounts/account">
	<li><xsl:value-of select="@name"/></li>
</xsl:template>

<xsl:template match="filterSettings/categoryTags/categoryTag">
	<li><xsl:value-of select="@name"/></li>
</xsl:template>

<xsl:template match="filterSettings/userTags/userTag">
	<li><xsl:value-of select="@name"/></li>
</xsl:template>

</xsl:stylesheet>